<!doctype html>
<html lang="fr">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Vue.js</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <script src="{{ asset('js/app.js') }}"></script>
</head>

<body>
    <div id="app">
        <table class="table">
            <tr>
                <th>Nom</th>
                <th>Couleur</th>
                <th>Quantité par barquette</th>
                <th>Nombre de barquettes</th>
                <th>Total</th>
                <th>Disponibilité</th>
            </tr>
            <tr v-for="fruit in fruits">
                <td>@{{ fruit.nom }}</td>
                <td>@{{ fruit.couleur }}</td>
                <td>@{{ fruit.qpbarquette }}</td>
                <td v-on:click="ajoute(fruit)">@{{ fruit.barquettes }}</td>
                <td>@{{ total(fruit) }}</td>
                <td v-on:click="inverser(fruit)" v-bind:class="fruit.dispo ? 'bg-primary' : 'bg-danger'">
                </td>
            </tr>
            <tr>
                <td colspan="4">TOTAL GENERAL</td>
                <td>@{{ tousfruits }}</td>
                <td></td>
            </tr>
        </table>
    </div>

<script>
var app = new Vue({
    el: '#app',
    data: {
        fruits: []
    },
    methods: {
        ajoute: function(fruit) {
            fruit.barquettes++
        },
        total: function(fruit) {
            fruit.total = fruit.qpbarquette * fruit.barquettes;
            return fruit.total
        },
        inverser: function(fruit) {
            fruit.dispo = !fruit.dispo
        },
    },
    computed: {
        tousfruits: function() {
            var total = 0;
            this.fruits.forEach( function(fruit) {
                total += fruit.total
            });
            return total
        }
    },
    mounted: function () {
        // AVEC AXIOS
        axios.get('api/fruits')
            .then(response => {
                this.fruits = response.data
            })
            .catch(error => {
                console.log(error)
            })

        // AVEC jQUERY
        // let vm = this;
        // $.ajax({
        //     url: '/api/fruits',
        //     method: 'GET',
        //     success: function (data) {
        //         vm.fruits = data;
        //     },
        //     error: function (error) {
        //         console.log(error);
        //     }
        // });
    }
});
</script>

</body>

</html>

