var app = new Vue({
    el: '#app',
    data: {
        nom: "",
        sort: "asc",
        nb: "10",
        liste: [
            {  id: 0, nom:"marc" },
            {  id: 1, nom:"jean" },
            {  id: 2, nom:"roger" },
            {  id: 3, nom:"ginette" },
            {  id: 4, nom:"alfred" },
            {  id: 5, nom:"gertrude" },
            {  id: 6, nom:"kevin" },
            {  id: 7, nom:"paul" },
            {  id: 8, nom:"amanda" },
            {  id: 9, nom:"thierry" },
            {  id: 10, nom:"lucas" },
            {  id: 11, nom:"serge" },
        ]
    },
    computed: {
        filtering: function () {

            // REGEX
            var regex = new RegExp(this.nom, "i")
            var liste = this.liste.filter(function (item) {
                return item.nom.match(regex)
            })

            // TRI
            liste = this.sort == "asc" ?
                liste.sort((a, b) => a.nom < b.nom ? -1 : 1) :
                liste.sort((a, b) => a.nom < b.nom ? 1 : -1)

            // RENVOI
            return liste.slice(0, this.nb)
        }
    },
    methods: {
        az: function () {
            this.sort = this.sort == "asc" ? "desc" : "asc"
        }
    }
});

